Ext.data.JsonP.sol_common_IxUtils({"tagname":"class","name":"sol.common.IxUtils","autodetected":{"aliases":true,"alternateClassNames":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.IxUtils.js","href":"lib_sol.common.IxUtils.html#sol-common-IxUtils"}],"extends":"sol.Base","singleton":true,"author":[{"tagname":"author","name":"NM, ELO Digital Office GmbH","email":null}],"version":["1.03.006"],"eloall":true,"aliases":{},"alternateClassNames":[],"mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"CONST","tagname":"property","owner":"sol.common.IxUtils","id":"property-CONST","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkVersion","tagname":"method","owner":"sol.common.IxUtils","id":"method-checkVersion","meta":{"private":true}},{"name":"execute","tagname":"method","owner":"sol.common.IxUtils","id":"method-execute","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"optimizedExecute","tagname":"method","owner":"sol.common.IxUtils","id":"method-optimizedExecute","meta":{"protected":true}}],"code_type":"ext_define","id":"class-sol.common.IxUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.IxUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.IxUtils.html#sol-common-IxUtils' target='_blank'>lib_sol.common.IxUtils.js</a></div></pre><div class='doc-contents'><p>This class provides basic functionality for ix operations.</p>\n      <p class='version-tag'>Version: <b>1.03.006</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-CONST' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IxUtils'>sol.common.IxUtils</span><br/><a href='source/lib_sol.common.IxUtils.html#sol-common-IxUtils-property-CONST' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IxUtils-property-CONST' class='name expandable'>CONST</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{EVENT_TYPES: {ACTION: &quot;ACTION&quot;, REFRESH: &quot;REFRESH&quot;, GOTO: &quot;GOTO&quot;, SELECT: &quot;SELECT&quot;, VIEW: &quot;VIEW&quot;, DIALOG: &quot;DIALOG&quot;, ERROR: &quot;ERROR&quot;, FEEDBACK: &quot;FEEDBACK&quot;}, COMPONENTS: {IX: &quot;IX&quot;, AS: &quot;AS&quot;}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IxUtils'>sol.common.IxUtils</span><br/><a href='source/lib_sol.common.IxUtils.html#sol-common-IxUtils-method-checkVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IxUtils-method-checkVersion' class='name expandable'>checkVersion</a>( <span class='pre'>currentVersionString, requiredVersionString</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n        <p>Available since: <b>1.04.000</b></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currentVersionString</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>requiredVersionString</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-execute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IxUtils'>sol.common.IxUtils</span><br/><a href='source/lib_sol.common.IxUtils.html#sol-common-IxUtils-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IxUtils-method-execute' class='name expandable'>execute</a>( <span class='pre'>funcName, paramObj, successFct, failureFct, proxyCfg</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Executes an ix registered function thanks to its name. ...</div><div class='long'><p>Executes an ix registered function thanks to its name.\nHandles the transformation of ix Any-Objects.</p>\n\n<p>Please note that executing Index Server calls in Web Applications must be done asynchronously doe to performance\nreasons.</p>\n\n<p>Example for Rhino engine scripts (sync) (IX, AS, Java Client)</p>\n\n<pre><code>var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  objId: '1'\n});\n</code></pre>\n\n<p>Example for ELO Web Client &amp; ELO Apps (async)</p>\n\n<pre><code>var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  objId: '1'\n}, function (result) {\n  // success\n}, function () {\n  // error\n};\n</code></pre>\n\n<h1>Performance optimizatios in ELO Apps (since ELOwf 10.01.002)</h1>\n\n<p>ELO Apps allow establishing IX connections without loading the IXClient.js file.\nThis is handled by the module elo.module.session.light` and will lead to a performance\nboost at startup time. Keep in mind that only Registered Function calls are supported.</p>\n\n<h1>Use custom IndexServer connection</h1>\n\n<p>You can use your own ix connection object</p>\n\n<p>   var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_FunctionName\",\n       {\n         objId: 1\n       },\n       null,\n       null,\n       {\n         connection: customConnection\n       }\n     )</p>\n\n<p>Hint: Using custom connection object is only supported in rhino</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>paramObj</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>successFct</span> : Function<div class='sub-desc'><p>success handler. required if executing scripts in the Web Client</p>\n</div></li><li><span class='pre'>failureFct</span> : Function<div class='sub-desc'><p>error handler. required if executing scripts in the Web Client</p>\n</div></li><li><span class='pre'>proxyCfg</span> : Object<div class='sub-desc'><p>proxy configuration</p>\n<ul><li><span class='pre'>connection</span> : Object<div class='sub-desc'><p>Function should be called with these connection instead of default connection.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>jsonResult only returned if call is sync.</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-optimizedExecute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IxUtils'>sol.common.IxUtils</span><br/><a href='source/lib_sol.common.IxUtils.html#sol-common-IxUtils-method-optimizedExecute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IxUtils-method-optimizedExecute' class='name expandable'>optimizedExecute</a>( <span class='pre'>rf, config, cacheObject, [optimization], [excludeFromConfig]</span> ) : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Wraps ixUtils.execute for optimized execution\nThe RF must implement an optimization mechanism which returns an optimi...</div><div class='long'><p>Wraps ixUtils.execute for optimized execution\nThe RF must implement an optimization mechanism which returns an optimization id if called with <code>optimize:true</code>\nand uses the optimization, also returning the id, if passed said optimization id as <code>optimize:&lt;optimizationId&gt;</code>.\n(Worst case, if the RF does not implement the mechanism the RF is executed as usual)\nAn optimization id can be any number/string, but it should be unique. An example for such an RF is sol.common.service.SordProvider</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rf</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>params for RF</p>\n</div></li><li><span class='pre'>cacheObject</span> : Object<div class='sub-desc'><p>should be a persistent javascript object in your calling class. Will hold optimization ids.</p>\n</div></li><li><span class='pre'>optimization</span> : String (optional)<div class='sub-desc'><p>give an optimization a name. This must be used, if optimizedExecute is called</p>\n</div></li><li><span class='pre'>excludeFromConfig</span> : String[] (optional)<div class='sub-desc'><p>define multiple config properties which will be set to undefined if optimization is available</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>whatever the RF returns</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});